/////////////////////////////////////////////////////////////////////////////
// LogoxAppDlg.h : Header-Datei
// (C) Copyright G DATA Software AG 1992-2001

#ifndef _LOGOXAPPDLG_H__
#define _LOGOXAPPDLG_H__

#if _MSC_VER > 1000
#pragma once
#endif

/////////////////////////////////////////////////////////////////////////////
// Includes
#include "Lgx4.h"

/////////////////////////////////////////////////////////////////////////////
// Defines
#define WM_NOTIFY_ACTION		WM_USER+100
#define WM_NOTIFY_MARK			WM_USER+101
#define WM_NOTIFY_CHUNK			WM_USER+102
#define WM_NOTIFY_PARAM			WM_USER+103
#define WM_NOTIFY_SENTENCE		WM_USER+104
#define WM_NOTIFY_WORD			WM_USER+105
#define WM_NOTIFY_MOUTH			WM_USER+106
#define WM_NOTIFY_VISEME		WM_USER+107

/////////////////////////////////////////////////////////////////////////////
// CLogoxAppDlg 
class CLogoxAppDlg : public CDialog
{
	public:
	CLogoxAppDlg(CWnd* pParent = NULL);

	protected:
	void GetParamFromLogox();
	void SetParamToLogox();

	void RefreshFonts();
	void RefreshStatics();

	//{{AFX_DATA(CLogoxAppDlg)
	enum { IDD = IDD_LOGOXAPP_DIALOG };
	CListBox	m_ctrlNotify;
	CComboBox	m_ctrlFont;
	CEdit	m_ctrlText;
	CSliderCtrl	m_ctrlSlideRoughness;
	CSliderCtrl	m_ctrlSlideIntonation;
	CSliderCtrl	m_ctrlSlideSpeed;
	CSliderCtrl	m_ctrlSlidePitch;
	CSliderCtrl	m_ctrlSlideVolume;
	BOOL	m_bMouth;
	BOOL	m_bChunk;
	BOOL	m_bAction;
	BOOL	m_bParam;
	BOOL	m_bSentence;
	BOOL	m_bViseme;
	BOOL	m_bWord;
	BOOL	m_bLineMark;
	BOOL	m_bMark;
	CString	m_szText;
	DWORD	m_dwActionID;
	int		m_iIntonation;
	int		m_iPitch;
	int		m_iRoughness;
	int		m_iSpeed;
	int		m_iVolume;
	CString	m_szIntonation;
	CString	m_szPitch;
	CString	m_szRoughness;
	CString	m_szSpeed;
	CString	m_szVolume;
	int		m_iFont;
	BOOL	m_bNotifyGlobal;
	//}}AFX_DATA

	// Vom Klassenassistenten generierte berladungen virtueller Funktionen
	//{{AFX_VIRTUAL(CLogoxAppDlg)
	protected:
	virtual void DoDataExchange(CDataExchange* pDX);
	virtual void OnOK();
	virtual void OnCancel();
	//}}AFX_VIRTUAL

	// Implementierung
	protected:
	HICON m_hIcon;

	// Generierte Message-Map-Funktionen
	//{{AFX_MSG(CLogoxAppDlg)
	virtual BOOL OnInitDialog();
	afx_msg void OnSysCommand(UINT nID, LPARAM lParam);
	afx_msg void OnPaint();
	afx_msg HCURSOR OnQueryDragIcon();
	afx_msg void OnSpeak();
	afx_msg void OnPause();
	afx_msg void OnStop();
	afx_msg void OnRecord();
	afx_msg void OnClear();
	afx_msg void OnUpdateNow();
	afx_msg void OnSelendokFont();
	afx_msg void OnNotifyGlobal();
	afx_msg void OnHScroll(UINT nSBCode, UINT nPos, CScrollBar* pScrollBar);
	afx_msg void OnReset();
	afx_msg void OnSelectFont();
	//}}AFX_MSG
	afx_msg LRESULT OnNotifyViseme(WPARAM wParam,LPARAM lParam);
	afx_msg LRESULT OnNotifyMark(WPARAM wParam,LPARAM lParam);
	afx_msg LRESULT OnNotifyParam(WPARAM wParam,LPARAM lParam);
	afx_msg LRESULT OnNotifyMouth(WPARAM wParam,LPARAM lParam);
	afx_msg LRESULT OnNotifyWord(WPARAM wParam,LPARAM lParam);
	afx_msg LRESULT OnNotifySentence(WPARAM wParam,LPARAM lParam);
	afx_msg LRESULT OnNotifyChunk(WPARAM wParam,LPARAM lParam);
	afx_msg LRESULT OnNotifyAction(WPARAM wParam,LPARAM lParam);
	DECLARE_MESSAGE_MAP()
};

//{{AFX_INSERT_LOCATION}}

#endif
